const express = require('express')
const { create, upload, notices, update, deleted, public_notices, hsc_notices, hons_notices, degree_notices } = require('../controller/notice');
const adminauthMiddleware = require('../middleware/admin_auth_validator');

const router = express.Router()

// get notice with admin.
router.route('/').get(notices)
// allocated
router.route('/public').get(public_notices)
router.route('/hsc').get(hsc_notices)
router.route('/hons').get(hons_notices)
router.route('/degree').get(degree_notices)

// get notice with anyone

// get notice with student of classes.

// create notice.
router.route("/create").post(upload.single("attachment"), create);
// update
router.route("/update").post(upload.single("attachment"), update);
// delete
router.route('/delete/:id').delete(deleted)

module.exports = router
 