const express = require('express')
const { createsession, getsession, deletesession, updatesession, getclass, createclass, updateclass, deleteclass, getsection, createsection, updatesection, deletesection, getdepartment, createdepartment, updatedepartment, deletedepartment, getsubject, createsubject, updatesubject, deletesubject, getsubjectwithquery } = require('../controller/academic')

const router = express.Router()


// session
router.route('/session').get(getsession)
router.route('/session/create').post(createsession)
router.route('/session/update').post(updatesession)
router.route('/session/delete/:id').delete(deletesession)
// class
router.route('/class').get(getclass)
router.route('/class/create').post(createclass)
router.route('/class/update').post(updateclass)
router.route('/class/delete/:id').delete(deleteclass)
// section
router.route('/section').get(getsection)
router.route('/section/create').post(createsection)
router.route('/section/update').post(updatesection)
router.route('/section/delete/:id').delete(deletesection)
// department
router.route('/department').get(getdepartment)
router.route('/department/create').post(createdepartment)
router.route('/department/update').post(updatedepartment)
router.route('/department/delete/:id').delete(deletedepartment)
// subjects
router.route('/subject').get(getsubject)
router.route('/subject/:cid/:did/:type').get(getsubjectwithquery)
router.route('/subject/create').post(createsubject)
router.route('/subject/update').post(updatesubject)
router.route('/subject/delete/:id').delete(deletesubject)

module.exports = router