require('dotenv').config()
const express = require('express')
const cors = require('cors')
const setupRoute = require('./route/setup.js')
const unauthRoute = require('./route/unauth.js')
const studentRoute = require('./route/student.js')
const academicRoute = require('./route/academic.js')
const examAssigned = require('./route/examassign.js')
const adminRoute = require('./route/admin.js')
const examRoute = require('./route/exam.js')
const resultRoute = require('./route/result.js')
const subportalRoute = require('./route/subportal.js')
// new route
const noticeRoute = require('./route/notice.js')
const routineRoute = require('./route/routine.js')
const examroutineRoute = require('./route/exam_routine.js')
const galleryRoute = require('./route/gallery.js')
const videoRoute = require('./route/video.js')
const attandanceRoute = require('./route/attandance.js')
const smsRoute = require('./route/sms.js')
const teacherRoute = require('./route/teacher.js')
const studentauthRoute = require('./route/student-auth.js')
const webRoute = require('./route/web.js')
const instructorRoute = require('./route/instructors.js')
const commiteeRoute = require('./route/comitee.js')
const themeRoute = require('./route/theme.js')
const leterRoute = require('./route/leter.js')
const paymentRoute = require('./route/payment.js')
const testRoute = require('./route/test.js')

const app = express()

// setting of the applicaiton.
app.use(express.json())
app.use(express.urlencoded({ extended: true })); // ✅ Enables form-data parsing
app.use(cors({
    origin:"*",
    methods:["GET, POST, DELETE, PUT, PATCH"],
    credentials:true,
    allowedHeaders: ["Authorization", "Content-Type"]
}))

// define an static routes.
app.use('/uploads/admin/', express.static('uploads/admin/'));
app.use('/uploads/banar/', express.static('uploads/banar/'));
app.use('/uploads/student/', express.static('uploads/student/'));
app.use('/uploads/teacher/', express.static('uploads/teacher/'));
app.use('/uploads/system/', express.static('uploads/system/'))
app.use('/uploads/notice/', express.static('uploads/notice/'))
app.use('/uploads/routine/', express.static('uploads/routine/'))
app.use('/uploads/exam_routine/', express.static('uploads/exam_routine/'))
app.use('/uploads/gallery/', express.static('uploads/gallery/'))
app.use('/uploads/instructor/', express.static('uploads/instructor/'))
app.use('/uploads/commitee/', express.static('uploads/commitee/'))
app.use('/uploads/theme/', express.static('uploads/theme/'))


// router initialization 
app.use('/api/setup', setupRoute)
app.use('/api/admin', adminRoute)
app.use('/api/academic', academicRoute)
app.use('/api/student', studentRoute)
app.use('/api/system', unauthRoute)
app.use('/api/exam', examRoute)
app.use('/api/result', resultRoute)
app.use('/api/examassigned', examAssigned)
app.use('/api/subportal', subportalRoute)
// new
app.use('/api/notice', noticeRoute)
app.use('/api/routine', routineRoute)
app.use('/api/exam_routine', examroutineRoute)
app.use('/api/gallery', galleryRoute)
app.use('/api/video', videoRoute)
app.use('/api/attandance', attandanceRoute)
app.use('/api/sms', smsRoute)
app.use('/api/teacher', teacherRoute)
app.use('/api/auth/student', studentauthRoute)
app.use('/api/web', webRoute)
app.use('/api/instructor', instructorRoute)
app.use('/api/committe', commiteeRoute)
app.use('/api/theme', themeRoute)
app.use('/api/leter', leterRoute)
app.use('/api/payment', paymentRoute)
app.use('/api/test', testRoute) // call

// listining port on server 
const PORT = process.env.PORT;
    app.listen( PORT, ()=>{
        console.log('Back end server is running..', PORT)
    })