const db = require('../utils/db');
const util = require('util');

const query = util.promisify(db.query).bind(db);

const getinfo = async (req, res, next) => {
  try {
    const [
      session,
      examination,
      classData,
      section,
      department,
      site
    ] = await Promise.all([
      query(`SELECT id, session FROM session`),
      query(`SELECT id, name FROM exam WHERE status = 2`),
      query(`SELECT id, name FROM classes ORDER BY createat ASC`),
      query(`SELECT id, name FROM sections`),
      query(`SELECT id, name FROM departments`),
      query(`SELECT * FROM site WHERE id = 1`)
    ]);

    const data = {
      session,
      exam: examination,
      class: classData,
      section,
      department,
      appdata: site[0] || {}
    };

    res.status(200).json({ message: 'no problem!', data });
  } catch (error) {
    next(error);
  }
};

module.exports = { getinfo };
