const db = require('../utils/db.js')
const fs = require('fs')
const bcrypt = require('bcryptjs')

// import controller function.

// update site info.
const setupupdate = async(req, res, next)=>{
    const {nameen, namebn, shortname, addressen, addressbn, eiinno, estd, maindomain, subdomain, studentportal, pnumber, gmail } = req.body;
    const updatesql = `UPDATE site SET nameen = ?, namebn = ?, shortname = ?, addressen = ?, addressbn = ?, eiinno = ?, estd = ?, maindomain = ?, subdomain = ?, studentportal = ?, pnumber = ?, gmail = ?
    WHERE id = ?`;
    const id = '1';
    try {
        // create new admin, status 3.
        db.query(updatesql, [nameen,namebn, shortname, addressen, addressbn, eiinno, estd, maindomain, subdomain, studentportal, pnumber, gmail, id], (err, result)=>{
            if(err) return res.status(400).json({message:err})
            res.status(200).json({message:'Credential Updated.'})
        })
    } catch (error) {
        next(error)
    }
}
// update admin info.
const updateadmin = async(req, res, next)=>{
    const {name, phone, password} = req.body;
    const updatesql = `UPDATE admin SET name = ?, phone = ?, password = ? WHERE status = ?`;
    const status = '3';
    try {
        const hashedPassword = await bcrypt.hash(password, 10);
        // hash password.
        // create new admin, status 3.
        db.query(updatesql, [name,phone, hashedPassword, status], (err, result)=>{
            if(err) return res.status(400).json({message:err})
            res.status(200).json({message:'Credential Updated.'})
        })
    } catch (error) {
        next(error)
    }
}
// update site logo.
const updatesitelogo = async(req, res, next)=>{
    try {
        const filename = req.file.filename;
        const checksql = 'SELECT id,image FROM site WHERE id = ?';
        const updatesql = `UPDATE site SET sitelogo = ? WHERE id = ?`;
        db.query(checksql, ['1'], (err, result)=>{
            const oldimage = result[0].sitelogo;
            try{
                if(req.file){
                    fs.unlinkSync('uploads/system/' + oldimage);
                }
            }catch(err){
                console.log('')
            }
            db.query(updatesql, [filename, '1'], (err, updateresult)=>{
                if(err){
                    return res.status(406).json({message:err})
                }
                res.status(201).json({message:'Site logo is updated.'})
            })
        });
    } catch (error) {
        next(error)
    }
}
const updatesignature = async(req, res, next)=>{
    try {
        const filename = req.file.filename;
        const checksql = 'SELECT id,image FROM site WHERE id = ?';
        const updatesql = `UPDATE site SET signature = ? WHERE id = ?`;
        db.query(checksql, ['1'], (err, result)=>{
            const oldimage = result[0].signature;
            try{
                if(req.file){
                    fs.unlinkSync('uploads/system/' + oldimage);
                }
            }catch(err){
                console.log('')
            }
            db.query(updatesql, [filename, '1'], (err, updateresult)=>{
                if(err){
                    return res.status(406).json({message:err})
                }
                res.status(201).json({message:'Signature is updated.'})
            })
        });
    } catch (error) {
        next(error)
    }
}
// update logo, env variable.
const resetdata = async(req, res, next)=>{
    const sql1 = `DELETE FROM admin WHERE status != 3`;
    const sql2 = `DELETE FROM students`;
    const sql3 = `DELETE FROM teachers`;
    const sql4 = `DELETE FROM session`;
    const sql5 = `DELETE FROM session`;
    const sql6 = `DELETE FROM classes`;
    const sql7 = `DELETE FROM sections`;
    const sql8 = `DELETE FROM departments`;
    const sql9 = `DELETE FROM subjects`;
    const sql10 = `DELETE FROM datetime`;
    const sql11 = `DELETE FROM exam`;
    const sql12 = `DELETE FROM exam_assinged`; 
    const sql13 = `DELETE FROM results`;
    const sql14 = `DELETE FROM result_items`;
    const sql15 = `DELETE FROM subject_assigned`;
    const sql16 = `DELETE FROM subject_grading`;
    try {
        // reset. admin (status 3 not), students, teachers, session, classes, sections, departments, subjects, datetime, exam, exam_assigned, results, result_items, subject_assigned, subject_grading.
        db.query(sql1)
        db.query(sql2)
        db.query(sql3)
        db.query(sql4)
        db.query(sql5)
        db.query(sql6)
        db.query(sql7)
        db.query(sql8)
        db.query(sql9)
        db.query(sql10)
        db.query(sql11)
        db.query(sql12)
        db.query(sql13)
        db.query(sql14)
        db.query(sql15)
        db.query(sql16)
        res.status(200).json({message:'empty table'})
    } catch (error) {
        next(error)
    }
}

module.exports = {setupupdate, resetdata, updatesitelogo, updatesignature, updateadmin}